"""
Copyright 3deoskill - Thomas Bösl 2020-2023
3deoskill.com

"""

import c4d
from c4d import gui
from c4d import storage,bitmaps
import os


def main():
    patho=c4d.GetGlobalTexturePath(0)
    img = storage.LoadDialog(c4d.FILESELECTTYPE_IMAGES, flags=c4d.FILESELECT_LOAD, title="Image", def_path=patho, def_file="")
    img_name = os.path.splitext(os.path.split(img)[1])[0]

    bitmap = c4d.bitmaps.BaseBitmap()
    bitmap.InitWith(img, frame=-1)
    x, y = bitmap.GetSize()


    plane = c4d.BaseObject(c4d.Oplane)
    plane.SetName(img_name)
    plane[c4d.PRIM_PLANE_SUBH] = 1
    plane[c4d.PRIM_PLANE_SUBW] = 1
    plane[c4d.PRIM_PLANE_WIDTH] = x/10
    plane[c4d.PRIM_PLANE_HEIGHT] = y/10
    plane[c4d.PRIM_AXIS]=5

    #=============Shader anlegen============================================
    imgshade = c4d.BaseList2D(c4d.Xbitmap)
    imgshade_alpha = c4d.BaseList2D(c4d.Xbitmap)

    #=============Material anlegen==========================================
    mat = c4d.Material()
    mat.SetName(img_name)
    mat.SetChannelState(c4d.CHANNEL_COLOR, True)
    mat.SetChannelState(c4d.CHANNEL_REFLECTION, False)

    mat[c4d.MATERIAL_COLOR_SHADER] = imgshade
    #mat[c4d.MATERIAL_ALPHA_SHADER]=imgshade_alpha
    imgshade[c4d.BITMAPSHADER_FILENAME] = img
    imgshade_alpha[c4d.BITMAPSHADER_FILENAME] = img
    mat.InsertShader(imgshade)

    #=======Asking for Alpha-Channel=============================
    if bitmap.GetChannelCount() == True:
        mat[c4d.MATERIAL_ALPHA_SHADER] = imgshade_alpha
        mat.InsertShader(imgshade_alpha)
        mat.SetChannelState(c4d.CHANNEL_ALPHA,True)

    else:
        mat.SetChannelState(c4d.CHANNEL_ALPHA,False)

    #======Texture-Tag anlegen==============================================
    texture_tag = c4d.BaseTag(c4d.Ttexture)
    plane.InsertTag(texture_tag)
    plane.InsertTag(c4d.BaseTag(c4d.Tphong))

    texture_tag[c4d.TEXTURETAG_MATERIAL] = mat
    texture_tag[c4d.TEXTURETAG_PROJECTION]=6
    plane[c4d.ID_BASEOBJECT_REL_POSITION,c4d.VECTOR_Y] = plane[c4d.PRIM_PLANE_HEIGHT]/2

    doc.InsertObject(plane)
    doc.InsertMaterial(mat,checknames=True)

    #doc.SetActiveTag(texture_tag)
    c4d.CallCommand(12132, 12132)
    op=doc.SetActiveObject(plane)
    #doc.InsertObject(op.GetClone())

    c4d.EventAdd()




# Execute main()
if __name__=='__main__':
    main()